
*********************************************************************************
***     ANALYSIS: "Stable relationships, stable participation?"			      ***
***		DATA:  - Pairfam waves 1 to 6, Release 6.0 							  ***
***			   - Paradata waves 3 to 7 (available upon request) 			  ***
***																		      ***	
*** 	CONTENT: Data preparation 										      ***
***		       - Variables on residential moves, percentage item-nonresponse, ***
***				 number of items & home ownership  							  ***
***		       - Exclusion DemoDiff sample 								  	  ***
***		       - Preparation paradata 					    			      ***
*********************************************************************************


** >> Do-File used in 1 DataPrep

cd $path1


*** Generate variable on residential moves from data set biomob_ehc_moves
forvalues x=1/5 {

	preserve
		local plus1=`x'+1

	use biomob_ehc_moves, clear
	drop if demodiff==1
	keep id mig0_w`x'_w`plus1'_mr within_w`x'_w`plus1'_mr 

	gen moves=0
	replace moves=1 if mig0_w`x'_w`plus1'_mr>0 | within_w`x'_w`plus1'_mr>0	

	save biomob`plus1'.dta, replace
	restore
}



*** Generate variables percentage item-nonresponse & number of items

** Wave 1
use anchor1, clear

egen filterq = anycount(dobd-sat6), values (-3)		
egen itemtot = rownonmiss(dobd-sat6) 				
egen inr = anycount(dobd-sat6), values (-2 -1)

gen nbitems= itemtot-filterq
gen pct_inr= inr / nbitems *100

label var nbitems  "Number of items asked"
label var pct_inr  "Percentage item-nonresponse"

drop filterq* itemtot* inr*

save anchor1p, replace


** Wave 2
use anchor2, clear

egen filterq = anycount(original_dobm-srs1i5 hc4h1-sat6), values (-3)		
egen itemtot = rownonmiss(original_dobm-srs1i5 hc4h1-sat6) 			
egen inr = anycount(original_dobm-srs1i5 hc4h1-sat6), values (-2 -1)

gen nbitems= itemtot-filterq
gen pct_inr= inr/ nbitems * 100


label var nbitems  "Number of items asked"
label var pct_inr  "Percentage item-nonresponse"
		
merge 1:1 id using biomob2.dta, keepusing(moves)
drop if _merge==2
drop _merge
	
save anchor2p, replace


** Wave 3
use anchor3, clear

drop if demodiff==1						// drop DemoDiff sample

egen filterq = anycount(original_dobm-srs1i5 hc6h1-sat6), values (-3)		
egen itemtot = rownonmiss(original_dobm-srs1i5 hc6h1-sat6) 				
egen inr = anycount(original_dobm-srs1i5 hc6h1-sat6), values (-2 -1)

gen nbitems= itemtot-filterq

gen pct_inr= inr/ nbitems * 100

label var nbitems  "Number of items asked"
label var pct_inr  "Percentage item-nonresponse"

* merge variable on residential moves	
merge 1:1 id using biomob3.dta, keepusing(moves)
drop if _merge==2
drop _merge
	

save anchor3p, replace


** Waves 4-5
forvalues x=4/5{
use anchor`x', clear

drop if demodiff==1						// drop DemoDiff sample

egen filterq = anycount(original_dobm-srs1i5 pa31-sat6), values (-3)		
egen itemtot = rownonmiss(original_dobm-srs1i5 pa31-sat6) 				
egen inr = anycount(original_dobm-srs1i5 pa31-sat6), values (-2 -1)

gen nbitems= itemtot-filterq
gen pct_inr= inr/ nbitems * 100

label var nbitems  "Number of items asked"
label var pct_inr  "Percentage item-nonresponse"
	
merge 1:1 id using biomob`x'.dta, keepusing(moves)
drop if _merge==2
drop _merge
	

save anchor`x'p.dta, replace
}


** Wave 6
use anchor6, clear

drop if demodiff==1						// drop DemoDiff sample
drop exp

egen filterq = anycount(original_dobm-srs1i5 pa31-sat6), values (-3)		
egen itemtot = rownonmiss(original_dobm-srs1i5 pa31-sat6) 				
egen inr = anycount(original_dobm-srs1i5 pa31-sat6), values (-2 -1)

gen nbitems= itemtot-filterq
gen pct_inr= inr/ nbitems * 100


label var nbitems  "Number of items asked"
label var pct_inr  "Percentage item-nonresponse"

	
merge 1:1 id using biomob6.dta, keepusing(moves)
drop if _merge==2
drop _merge

save anchor6p, replace


*** Generate variable on home ownership

* Merge information on home ownership from waves 1 and 2 
use anchor3p, nol clear
ren hc5h1 hc5h1_w3

merge 1:1 id using anchor2p.dta, keepusing (id hc5h1)		
drop if _merge==2
rename hc5h1 hc5h1_w2
drop _merge

merge 1:1 id using anchor1p.dta, keepusing (id hc5h1)
rename hc5h1 hc5h1_w1
drop if _merge==2

replace hc5h1_w3=hc5h1_w2 if hc5h1_w3==-3	// wave 2 information for anchor persons without information on ownership in wave 3 due to filtering
replace hc5h1_w3=hc5h1_w1 if hc5h1_w3==.	// wave 1 information for temporary dropouts
ren hc5h1_w3 hc5h1 
tab hc5h1, m						
	
drop _merge hc5h1_w*
	
save anchor3p, replace 

forvalues x=4/6{
	use anchor`x'p, nol clear
	
	ren hc5h1 hc5h1_w`x'
	merge 1:1 id using anchor2.dta, keepusing (id hc5h1)		
	drop if _merge==2
	rename hc5h1 hc5h1_w2
	drop _merge
	
	merge 1:1 id using anchor1.dta, keepusing (id hc5h1)
	rename hc5h1 hc5h1_w1
	drop if _merge==2
	
	replace hc5h1_w`x'=hc5h1_w2 if hc5h1_w`x'==-3	// wave 2 information for anchor persons without information on ownership in wave 4-6 
	replace hc5h1_w`x'=hc5h1_w1 if hc5h1_w`x'==.	// wave 1 information for temporary dropouts
	
	ren hc5h1_w`x' hc5h1
	*tab hc5h1, m						
	drop _merge hc5h1_w2 hc5h1_w1
	
	save anchor`x'p.dta, replace 
}




*** Paradata waves 3-7

* keep only relevant variables; standardize variable names; drop DemoDiff sample
use Bruttoband_Welle3.dta, clear	
	gen long id=hhid*1000
	ren konges nbcontact
	ren intnum_final intnum
	
	ren erg_end erg
	tab erg, m
	drop if inlist(erg,2,4)						// excluding deceased respondents and cases who no longer belong to target popuation 		
	
	keep id intnum listnum nbcontact erg
	sort intnum
save Bruttoband_Welle3red, replace

use Bruttoband_Welle4.dta, clear	
	gen long id=hhid*1000
	ren konges nbcontact
	
	tab erg, m
	drop if inlist(erg,2,4)						// excluding deceased respondents and cases who no longer belong to target popuation 		
	
	keep id intnum listnum nbcontact erg
	sort intnum
save Bruttoband_Welle4red, replace
	

forvalues x=5/6{
	forvalues j=4/5{
		use Bruttoband_Welle`x'.dta, clear	
		gen long id=hhid*1000
		drop if d0==2															// drop step-up respondents
		
		merge 1:1 id using stepup_anchor`j'.dta, keepusing(f_cid)				// drop step-ups respondents 
		drop if f_cid!=.
		drop f_cid _merge
		

		drop if id>800000000					// drop DemoDiff sample
		ren konges nbcontact
		
		tab erg, m
		drop if erg==6							// excluding deceased respondents and cases who no longer belong to target popuation 		
		
		keep id intnum listnum nbcontact erg
		sort intnum
		save Bruttoband_Welle`x'red, replace
	}
}

use Bruttoband_Welle7.dta, clear	
	gen long id=hhid*1000
	drop if id>800000000						// drop DemoDiff sample
	drop if inlist(Kohorte,0,9)					// drop step-up respondents
	tab erg, m
	drop if erg==6								// excluding deceased respondents and cases who no longer belong to target popuation 		
	
	keep id erg d0
	sort id
save Bruttoband_Welle7red, replace
